//
//  Detecting_Tap_GesturesViewController.m
//  Detecting Tap Gestures
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Detecting_Tap_GesturesViewController.h"

@implementation Detecting_Tap_GesturesViewController

@synthesize tapGestureRecognizer;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (void) handleTaps:(UITapGestureRecognizer*)paramSender{
  
  NSUInteger touchCounter = 0;
  for (touchCounter = 0;
       touchCounter < paramSender.numberOfTouchesRequired;
       touchCounter++){
    CGPoint touchPoint = 
    [paramSender locationOfTouch:touchCounter 
                          inView:paramSender.view];
    NSLog(@"Dotyk #%lu: %@", 
          (unsigned long)touchCounter+1,
          NSStringFromCGPoint(touchPoint));
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  /* Utworzenie procedury rozpoznawania gestów stuknięcia. */
  self.tapGestureRecognizer = [[UITapGestureRecognizer alloc] 
                               initWithTarget:self
                               action:@selector(handleTaps:)];
  
  /* Liczba palców, które muszą znajdować się na ekranie. */
  self.tapGestureRecognizer.numberOfTouchesRequired = 2;
  
  /* Całkowita liczba stuknięć, które muszą być wykonane, zanim gest zostanie rozpoznany. */
  self.tapGestureRecognizer.numberOfTapsRequired = 3;
  
  /* Dodanie procedury rozpoznawania gestów do widoku. */
  [self.view addGestureRecognizer:self.tapGestureRecognizer];
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  self.tapGestureRecognizer = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
